//
//  MCObserverProtocol.h
//  MCFoundation
//
//  Created by aj on Sat Sep 08 2001.
//  Copyright (c) 2001 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol MCObserver <NSObject>

- (void)observedObjectDidChange:(id)anObject;
- (void)observedObjectWillDeallocate:(id)anObject;


/*
Listening to selections and unselection. anObject is the 
selected or unselected object. anEvent is usually and NSEvent 
object (it's not defined in foundation so we declare it as 
an id here). anEvent can be nil.  It is expected that an event 
is passed along from the selecting view if a modifier key 
has been pressed.
*/
- (void)observedObjectDidSelect:(id)anObject withEvent:(id)anEvent;
- (void)observedObjectDidUnselect:(id)anObject withEvent:(id)anEvent;

@end
